/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.constants.AnimationType;
import noppes.npcs.api.constants.EntityType;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.constants.MarkType;
import noppes.npcs.api.constants.OptionType;
import noppes.npcs.api.constants.ParticleType;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.api.constants.SideType;
import noppes.npcs.api.constants.TacticalType;
import noppes.npcs.api.event.BlockEvent;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.api.handler.IDataObject;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.DataObject;
import noppes.npcs.api.wrapper.data.Data;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataScript;
import noppes.npcs.reflection.nbt.TagLongArrayReflection;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.ScriptEncryption;
import noppes.npcs.util.Util;

public class ScriptContainer {
    public static ScriptContainer Current;
    public static HashMap<String, Object> Data;
    private static Method luaCall;
    private static Method luaCoerce;
    private static final Executor executor;
    public static final ConcurrentSkipListMap<Long, ScriptEngine> contexts;
    private static final ConcurrentSkipListMap<String, ExecutorService> links;
    public TreeMap<Long, String> console = new TreeMap();
    public ScriptEngine engine = null;
    public boolean isClient;
    public boolean errored = false;
    private String fullscript = null;
    private boolean hasNoEncryptScriptCode = false;
    private final IScriptHandler handler;
    public long lastCreated = 0L;
    public String script = "";
    public List<String> scripts = new ArrayList<String>();
    private HashSet<String> unknownFunctions = new HashSet();

    private static void FillMap(Class<?> c) {
        if (!c.isEnum()) {
            return;
        }
        Data.put(c.getSimpleName(), c.getDeclaringClass() != null ? c.getDeclaringClass() : c);
        for (Object e : c.getEnumConstants()) {
            try {
                Method m = e.getClass().getMethod("get", new Class[0]);
                if (m.getReturnType() != Integer.TYPE) continue;
                Data.put(c.getSimpleName() + "_" + ((Enum)e).name(), m.invoke(e, new Object[0]));
            }
            catch (Throwable error) {
                LogWriter.error(error);
            }
        }
    }

    private static Object getNBTValue(NBTBase tag) {
        Object value = null;
        switch (tag.func_74732_a()) {
            case 1: {
                value = ((NBTTagByte)tag).func_150290_f();
                break;
            }
            case 2: {
                value = ((NBTTagShort)tag).func_150289_e();
                break;
            }
            case 3: {
                value = ((NBTTagInt)tag).func_150287_d();
                break;
            }
            case 4: {
                value = ((NBTTagLong)tag).func_150291_c();
                break;
            }
            case 5: {
                value = Float.valueOf(((NBTTagFloat)tag).func_150288_h());
                break;
            }
            case 6: {
                value = ((NBTTagDouble)tag).func_150286_g();
                break;
            }
            case 7: {
                value = ((NBTTagByteArray)tag).func_150292_c();
                break;
            }
            case 8: {
                value = ((NBTTagString)tag).func_150285_a_();
                break;
            }
            case 9: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (NBTBase obj : (NBTTagList)tag) {
                    Object v = ScriptContainer.getNBTValue(obj);
                    if (v == null) continue;
                    list.add(v);
                }
                value = list.toArray(new Object[0]);
                break;
            }
            case 10: {
                TreeMap<String, Object> comp = new TreeMap<String, Object>();
                for (String key : ((NBTTagCompound)tag).func_150296_c()) {
                    Object v = ScriptContainer.getNBTValue(((NBTTagCompound)tag).func_74781_a(key));
                    if (v == null) continue;
                    comp.put(key, v);
                }
                value = comp;
                break;
            }
            case 11: {
                value = ((NBTTagIntArray)tag).func_150302_c();
                break;
            }
            case 12: {
                value = TagLongArrayReflection.getData((NBTTagLongArray)tag);
            }
        }
        return value;
    }

    public static void reloadConstants() {
        Data.remove("dump");
    }

    public ScriptContainer(IScriptHandler handlerIn, boolean isClientIn) {
        this.handler = handlerIn;
        this.isClient = isClientIn;
    }

    public ScriptContainer copyTo(IScriptHandler scriptHandler) {
        ScriptContainer scriptContainer = new ScriptContainer(scriptHandler, this.isClient);
        scriptContainer.readFromNBT(this.writeToNBT(new NBTTagCompound()), this.isClient);
        return scriptContainer;
    }

    public boolean hasHandler() {
        if (this.handler == null) {
            return false;
        }
        if (this.handler instanceof DataScript) {
            EntityNPCInterface npc = ((DataScript)this.handler).npc;
            try {
                return npc != null && npc.field_70170_p != null && npc.func_145782_y() > 0 && npc.equals(npc.field_70170_p.func_73045_a(npc.func_145782_y()));
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        if (this.handler instanceof TileNpcEntity) {
            if (!((TileNpcEntity)((Object)this.handler)).func_145830_o()) {
                return false;
            }
            BlockPos pos = ((TileNpcEntity)((Object)this.handler)).func_174877_v();
            return ((TileNpcEntity)((Object)this.handler)).func_145831_w().func_175625_s(pos) instanceof IScriptBlockHandler;
        }
        return true;
    }

    public ITextComponent noticeString() {
        return this.hasHandler() ? this.handler.noticeString(null, null) : null;
    }

    public void appendConsole(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.console.containsKey(time)) {
            message = this.console.get(time) + "\n" + message;
        }
        this.console.put(time, message);
        while (this.console.size() > 30) {
            this.console.remove(this.console.firstKey());
        }
        ScriptController.Instance.tryAddErrored(this);
    }

    public void clear() {
        this.script = "";
        this.fullscript = null;
        this.scripts.clear();
    }

    private String getTotalCode() {
        if (this.fullscript == null) {
            this.hasNoEncryptScriptCode = this.script != null && !this.script.isEmpty();
            this.fullscript = this.script;
            if (!this.fullscript.isEmpty()) {
                this.fullscript = this.fullscript + "\n";
            }
            ScriptController sData = ScriptController.Instance;
            Map<String, String> map = this.isClient ? sData.clients : sData.scripts;
            StringBuilder sbCode = new StringBuilder();
            for (String loc : this.scripts) {
                String code;
                if (!this.isClient && sData.encrypts.containsKey(loc)) {
                    code = ScriptEncryption.decryptScriptFromFile(sData.encrypts.get(loc));
                } else {
                    code = map.get(loc);
                    if (code != null) {
                        this.hasNoEncryptScriptCode = true;
                    }
                }
                if (code == null || code.isEmpty()) continue;
                sbCode.append(code).append("\n");
            }
            this.fullscript = this.fullscript + sbCode.toString();
            if (map.containsKey("all.js")) {
                this.fullscript = map.get("all.js") + "\n" + this.fullscript;
            }
            this.unknownFunctions = new HashSet();
        }
        return this.fullscript;
    }

    public boolean hasNoEncryptScriptCode() {
        boolean sr;
        boolean bl = sr = this.script != null && !this.script.isEmpty();
        if (sr) {
            String tempScript = this.script.replace(" ", "").replace("\t", "").replace("\n", "");
            sr = !tempScript.isEmpty();
        }
        return sr || this.hasNoEncryptScriptCode;
    }

    public boolean hasScriptCode() {
        return !this.getTotalCode().isEmpty();
    }

    public boolean isInit() {
        return this.fullscript != null;
    }

    public boolean isValid() {
        return this.isInit() && !this.errored;
    }

    public void readFromNBT(NBTTagCompound compound, boolean isClientIn) {
        if (compound.func_150297_b("Script", 9)) {
            NBTTagList list = compound.func_150295_c("Script", 8);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                sb.append(list.func_150307_f(i));
            }
            this.script = sb.toString();
        } else {
            this.script = compound.func_74779_i("Script");
        }
        this.console = NBTTags.GetLongStringMap(compound.func_150295_c("Console", 10));
        if (this.console.isEmpty()) {
            ScriptController.Instance.tryRemoveErrored(this);
        } else {
            ScriptController.Instance.tryAddErrored(this);
        }
        this.scripts = NBTTags.getStringList(compound.func_150295_c("ScriptList", 10));
        this.hasNoEncryptScriptCode = compound.func_74767_n("HasNoEncryptScriptCode");
        this.isClient = isClientIn;
        if (this.isClient) {
            this.errored = false;
        }
        this.lastCreated = 0L;
        this.fullscript = null;
        this.unknownFunctions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String type, Event event) {
        String key = event instanceof BlockEvent ? "Block" : (event instanceof PlayerEvent ? "Player" : (event instanceof ItemEvent ? "Item" : (event instanceof NpcEvent ? "Npc" : null)));
        CustomNpcs.debugData.start(key, type);
        if (this.engine == null) {
            this.setEngine(this.handler.getLanguage());
        }
        if (this.errored && this.console.isEmpty()) {
            this.errored = false;
            this.fullscript = null;
        }
        if (this.errored || !this.hasScriptCode() || this.unknownFunctions.contains(type) || !CustomNpcs.EnableScripting || this.engine == null) {
            CustomNpcs.debugData.end(key, type);
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastCreated) {
            this.lastCreated = ScriptController.Instance.lastLoaded;
            this.fullscript = null;
            this.hasNoEncryptScriptCode = false;
        }
        String string = "lock";
        synchronized ("lock") {
            Current = this;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                this.engine.getContext().setWriter(pw);
                this.engine.getContext().setErrorWriter(pw);
                if (this.engine.get("dump") == null) {
                    this.fillEngine(this.engine);
                } else if (this.isClient && (this.engine.get("mc") == null || this.engine.get("storedData") == null)) {
                    this.fillEngineClient(this.engine);
                }
                if (this.fullscript == null) {
                    this.engine.eval(this.getTotalCode());
                }
                if (this.engine.getFactory().getLanguageName().equals("lua")) {
                    Object ob = this.engine.get(type);
                    if (ob != null) {
                        if (luaCoerce == null) {
                            luaCoerce = Class.forName("org.luaj.vm2.lib.jse.CoerceJavaToLua").getMethod("coerce", Object.class);
                            luaCall = ob.getClass().getMethod("call", Class.forName("org.luaj.vm2.LuaValue"));
                        }
                        luaCall.invoke(ob, luaCoerce.invoke(null, event));
                    } else {
                        this.unknownFunctions.add(type);
                    }
                } else {
                    ((Invocable)((Object)this.engine)).invokeFunction(type, event);
                }
            }
            catch (NoSuchMethodException notFunction) {
                this.unknownFunctions.add(type);
            }
            catch (Throwable e) {
                this.errored = true;
                ITextComponent notice = this.handler.noticeString(type, event);
                String noticeToLog = Util.instance.deleteColor(notice.func_150254_d());
                pw.write(noticeToLog + "\n");
                e.printStackTrace(pw);
                LogWriter.debug("Script error: " + e);
                String errorText = "" + e;
                String errorName = "Error";
                try {
                    errorText = e.getCause().getLocalizedMessage().replaceAll("\r", "");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    errorName = e.getCause().getClass().getSimpleName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                StringBuilder error = new StringBuilder();
                if (errorText.contains("\n")) {
                    for (int c = 0; c < errorText.length(); ++c) {
                        error.append(errorText.charAt(c));
                        if (errorText.charAt(c) != '\n') continue;
                        error.append('\u00a7').append("8");
                    }
                } else {
                    error = new StringBuilder("\u00a78" + e);
                }
                TextComponentString errInfo = new TextComponentString("Script " + errorName + ": " + error);
                errInfo.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
                NoppesUtilServer.NotifyOPs(notice.func_150258_a("\n").func_150257_a((ITextComponent)errInfo), true);
                LogWriter.error(noticeToLog + " ", e);
            }
            finally {
                this.appendConsole(sw.getBuffer().toString().trim());
                pw.close();
                Current = null;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (!this.console.isEmpty()) {
                ScriptController.Instance.tryAddErrored(this);
            }
            CustomNpcs.debugData.end(key, type);
            return;
        }
    }

    public void runAsync(String link, String async, String sync, Object arguments) {
        if (!async.isEmpty()) {
            if (!link.isEmpty()) {
                if (!links.containsKey(link)) {
                    links.put(link, Executors.newSingleThreadExecutor());
                }
                links.get(link).execute(() -> this.generateAsyncContext(async, sync, arguments));
            } else {
                executor.execute(() -> this.generateAsyncContext(async, sync, arguments));
            }
        } else {
            this.runSync(sync, arguments);
        }
    }

    private void generateAsyncContext(String async, String sync, Object arguments) {
        try {
            ScriptEngine engine;
            if (!contexts.containsKey(Thread.currentThread().getId())) {
                engine = ScriptController.Instance.getEngineByName(this.handler.getLanguage());
                this.fillEngine(engine);
                Map<String, String> map = this.isClient ? ScriptController.Instance.clients : ScriptController.Instance.scripts;
                engine.eval(map.get("all.js") + "\n");
                contexts.put(Thread.currentThread().getId(), engine);
            }
            engine = contexts.get(Thread.currentThread().getId());
            engine.eval("var asyncFunction = (" + async + ");");
            Object result = ((Invocable)((Object)engine)).invokeFunction("asyncFunction", arguments);
            if (!sync.isEmpty()) {
                this.runSync(sync, result);
            }
        }
        catch (Throwable e) {
            LogWriter.error(this.handler.noticeString(async, null) + " script generate async context: ", e);
        }
    }

    private void runSync(String sync, Object arguments) {
        CustomNPCsScheduler.runTack(() -> {
            try {
                ((Invocable)((Object)this.engine)).invokeFunction(sync, arguments);
            }
            catch (Throwable e) {
                LogWriter.error(this.handler.noticeString(sync, null) + " script sync errored: ", e);
            }
        });
    }

    public void setEngine(String scriptLanguage) {
        this.engine = ScriptController.Instance.getEngineByName(scriptLanguage);
        this.fullscript = null;
        this.hasNoEncryptScriptCode = false;
        if (this.engine != null) {
            this.fillEngine(this.engine);
        }
        this.errored = this.engine == null;
    }

    private void fillEngine(ScriptEngine scriptEngine) {
        NBTTagCompound constants = ScriptController.Instance.constants;
        String language = Util.instance.deleteColor(this.handler.getLanguage()).toLowerCase();
        String side = this.isClient ? "Client" : "Server";
        boolean needResave = false;
        try {
            scriptEngine.put("Date", scriptEngine.eval("Java.type('" + Date.class.getName() + "')"));
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"Date\" to engine");
        }
        try {
            scriptEngine.put("Calendar", scriptEngine.eval("Java.type('" + Calendar.class.getName() + "')"));
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"Calendar\" to engine");
        }
        try {
            scriptEngine.put("System", scriptEngine.eval("Java.type('" + System.class.getName() + "')"));
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"System\" to engine");
        }
        NBTTagList functions = constants.func_74775_l("Functions").func_150295_c(language, 8);
        for (int i = 0; i < functions.func_74745_c(); ++i) {
            Iterator<Map.Entry<String, Object>> body = functions.func_150307_f(i);
            try {
                String key;
                if (!((String)((Object)body)).contains(" ") || !((String)((Object)body)).contains("(") || (key = ((String)((Object)body)).substring(((String)((Object)body)).indexOf(" ") + 1, ((String)((Object)body)).indexOf("("))).isEmpty()) continue;
                try {
                    Data.put(key, scriptEngine.eval((String)((Object)body)));
                }
                catch (Throwable e) {
                    LogWriter.error("Not add function key: \"" + body + "\"; body: \"" + body + "\" to data");
                    if (!constants.func_74775_l("Functions").func_150297_b("EvalIsError", 10)) {
                        constants.func_74775_l("Functions").func_74782_a("EvalIsError", (NBTBase)new NBTTagCompound());
                    }
                    if (!constants.func_74775_l("Functions").func_74775_l("EvalIsError").func_150297_b(side, 10)) {
                        constants.func_74775_l("Functions").func_74775_l("EvalIsError").func_74782_a(side, (NBTBase)new NBTTagCompound());
                    }
                    NBTTagList errors = constants.func_74775_l("Functions").func_74775_l("EvalIsError").func_74775_l(side).func_150295_c(language, 8);
                    boolean has = false;
                    for (int j = 0; j < errors.func_74745_c(); ++j) {
                        if (!errors.func_150307_f(i).equals(body)) continue;
                        has = true;
                        break;
                    }
                    if (has) continue;
                    errors.func_74742_a((NBTBase)new NBTTagString(e.getCause().getClass().getSimpleName() + ": " + body));
                    constants.func_74775_l("Functions").func_74775_l("EvalIsError").func_74775_l(side).func_74782_a(language, (NBTBase)errors);
                    needResave = true;
                }
                continue;
            }
            catch (Throwable e) {
                constants.func_150295_c("Functions", 10).func_150305_b(i).func_74757_a("EvalIsError", true);
            }
        }
        NBTTagCompound cons = constants.func_74775_l("Constants").func_74775_l(language);
        for (String key : cons.func_150296_c()) {
            Object value = ScriptContainer.getNBTValue(cons.func_74781_a(key));
            String err = "";
            if (value == null) {
                err = "NullPointerException";
            } else {
                try {
                    if (value instanceof String) {
                        try {
                            Data.put(key, scriptEngine.eval((String)value));
                        }
                        catch (Throwable e) {
                            Data.put(key, value);
                        }
                    } else {
                        Data.put(key, value);
                    }
                }
                catch (Throwable t) {
                    err = t.getCause().getClass().getSimpleName();
                }
            }
            if (err.isEmpty()) continue;
            LogWriter.error("Not add constant key: \"" + key + "\"; value: \"" + value + "\" to data");
            if (!constants.func_74775_l("Constants").func_150297_b("EvalIsError", 10)) {
                constants.func_74775_l("Constants").func_74782_a("EvalIsError", (NBTBase)new NBTTagCompound());
            }
            if (!constants.func_74775_l("Constants").func_74775_l("EvalIsError").func_150297_b(side, 10)) {
                constants.func_74775_l("Constants").func_74775_l("EvalIsError").func_74782_a(side, (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound errors = constants.func_74775_l("Constants").func_74775_l("EvalIsError").func_74775_l(side).func_74775_l(language);
            errors.func_74778_a(key, err);
            constants.func_74775_l("Constants").func_74775_l("EvalIsError").func_74775_l(side).func_74782_a(language, (NBTBase)errors);
            needResave = true;
        }
        Data.put("dump", new Dump());
        Data.put("log", new Log());
        for (Map.Entry<String, Object> entry : Data.entrySet()) {
            try {
                scriptEngine.put(entry.getKey(), entry.getValue());
            }
            catch (Throwable ignored) {
                LogWriter.error("Not put data key \"" + entry.getKey() + "\" to engine");
            }
        }
        if (this.isClient) {
            this.fillEngineClient(scriptEngine);
        }
        try {
            scriptEngine.put("cnpcs", CustomNpcs.instance);
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"cnpcs\" to engine");
        }
        try {
            scriptEngine.put("api", NpcAPI.Instance());
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"api\" to engine");
        }
        try {
            scriptEngine.put("currentThread", Thread.currentThread().getName());
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"currentThread\" to engine");
        }
        try {
            scriptEngine.put("main", scriptEngine);
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"main\" to engine");
        }
        try {
            scriptEngine.put("currentScriptContainer", this);
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"currentScriptContainer\" to engine");
        }
        try {
            scriptEngine.put("tempData", new Data());
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"tempData\" to engine");
        }
        if (needResave) {
            Util.instance.saveFile(ScriptController.Instance.constantScriptsFile(), constants.func_74737_b());
        }
    }

    private void fillEngineClient(ScriptEngine scriptEngine) {
        if (!this.isClient) {
            return;
        }
        try {
            scriptEngine.put("mc", ClientProxy.mcWrapper);
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"mc\" to engine");
        }
        try {
            scriptEngine.put("storedData", ScriptController.Instance.clientScripts.storedData);
        }
        catch (Throwable ignored) {
            LogWriter.error("Not put key \"storedData\" to engine");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Script", this.script);
        compound.func_74782_a("Console", (NBTBase)NBTTags.NBTLongStringMap(this.console));
        compound.func_74782_a("ScriptList", (NBTBase)NBTTags.nbtStringList(this.scripts));
        compound.func_74757_a("isClient", this.isClient);
        compound.func_74757_a("HasNoEncryptScriptCode", this.hasNoEncryptScriptCode);
        return compound;
    }

    static {
        Data = new HashMap();
        executor = Executors.newFixedThreadPool(16);
        contexts = new ConcurrentSkipListMap();
        links = new ConcurrentSkipListMap();
        ScriptContainer.FillMap(AnimationKind.class);
        ScriptContainer.FillMap(AnimationType.class);
        ScriptContainer.FillMap(EntityType.class);
        ScriptContainer.FillMap(GuiComponentType.class);
        ScriptContainer.FillMap(JobType.class);
        ScriptContainer.FillMap(MarkType.class);
        ScriptContainer.FillMap(OptionType.class);
        ScriptContainer.FillMap(ParticleType.class);
        ScriptContainer.FillMap(PotionEffectType.class);
        ScriptContainer.FillMap(RoleType.class);
        ScriptContainer.FillMap(SideType.class);
        ScriptContainer.FillMap(TacticalType.class);
        Data.put("api", NpcAPI.Instance());
        Data.put("API", NpcAPI.Instance());
        Data.put("cnpcs", CustomNpcs.instance);
        Data.put("PosZero", new BlockPosWrapper(BlockPos.field_177992_a));
    }

    public class Log
    implements Function<Object, Void> {
        @Override
        public Void apply(Object o) {
            String message = o == null ? "null" : o.toString();
            ScriptContainer.this.appendConsole(message);
            LogWriter.info(message);
            return null;
        }
    }

    public static class Dump
    implements Function<Object, IDataObject> {
        @Override
        public IDataObject apply(Object o) {
            return new DataObject(o);
        }
    }
}

